/*
 * Decompiled with CFR 0.152.
 */
package com.de.novelistic.codefractor.translator;

import com.de.novelistic.codefractor.translator.Translator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class TranslatorJava
extends Translator {
    private ArrayList<String> java_keywords = new ArrayList();

    public TranslatorJava() {
        this.readAnotherImportantFilesIn();
    }

    public static void main(String[] args) {
        TranslatorJava tj = new TranslatorJava();
        tj.printJavaKeywords();
    }

    @Override
    protected void readAnotherImportantFilesIn() {
        InputStream is = this.getClass().getResourceAsStream("java-keywords.txt");
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.java_keywords.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printJavaKeywords() {
        int i = 0;
        while (i < this.java_keywords.size()) {
            System.out.print(String.valueOf(this.java_keywords.get(i)) + ";");
            if (i % 5 == 0) {
                System.out.print("\n");
            }
            ++i;
        }
    }

    @Override
    protected String addAnotherTags(String toBeTagged) {
        String taggedSub;
        String tagged = toBeTagged;
        int i = 0;
        while (i < this.java_keywords.size()) {
            String kw = this.java_keywords.get(i);
            tagged = tagged.replaceAll(String.valueOf(kw) + " ", "<b>" + kw + "</b> ");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\n", "<b>" + kw + "</b>\n");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\.", "<b>" + kw + "\\.</b>");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\;", "<b>" + kw + "\\;</b>");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\{", "<b>" + kw + "</b>\\{");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\(", "<b>" + kw + "</b>\\(");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\(", "<b>" + kw + "</b>\\(");
            tagged = tagged.replaceAll(String.valueOf(kw) + "\\)", "<b>" + kw + "</b>\\)");
            ++i;
        }
        int comment_index = 0;
        int lineEnd_index = 0;
        while (true) {
            comment_index = tagged.indexOf("//", lineEnd_index);
            lineEnd_index = tagged.indexOf("<br>", comment_index);
            if (comment_index == -1) break;
            System.out.println(String.valueOf(comment_index) + " " + lineEnd_index);
            taggedSub = tagged.substring(comment_index, lineEnd_index);
            taggedSub = "<em class=\"ex_comment\">" + taggedSub + "</em>";
            tagged = String.valueOf(tagged.substring(0, comment_index)) + taggedSub + tagged.substring(lineEnd_index);
            lineEnd_index = tagged.indexOf("<br>", lineEnd_index);
            System.out.println(taggedSub);
        }
        comment_index = 0;
        lineEnd_index = 0;
        while (true) {
            comment_index = tagged.indexOf("/*", lineEnd_index);
            lineEnd_index = tagged.indexOf("*/", comment_index) + 2;
            if (comment_index == -1) break;
            taggedSub = tagged.substring(comment_index, lineEnd_index);
            taggedSub = "<em class=\"ex_comment\">" + taggedSub + "</em>";
            tagged = String.valueOf(tagged.substring(0, comment_index)) + taggedSub + tagged.substring(lineEnd_index);
            lineEnd_index = tagged.indexOf("<br>", lineEnd_index);
        }
        return tagged;
    }
}

