/*
 * Decompiled with CFR 0.152.
 */
package com.de.novelistic.codefractor.translator;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public abstract class Translator {
    protected HashMap<String, String> corrections = new HashMap();

    public Translator() {
        this.readFirstImportantFilesIn();
    }

    public final String translate(String toTranslate) {
        String translation = toTranslate;
        for (Map.Entry<String, String> entry : this.corrections.entrySet()) {
            translation = translation.replaceAll(entry.getKey(), entry.getValue());
        }
        translation = this.addFirstTags(translation);
        translation = this.addAnotherTags(translation);
        return translation;
    }

    private void readFirstImportantFilesIn() {
        InputStream is = this.getClass().getResourceAsStream("corrections.txt");
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                int findSep = line.indexOf(61);
                String key = line.substring(0, findSep);
                String value = line.substring(findSep + 1);
                this.corrections.put(key, value);
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String addFirstTags(String toBeTagged) {
        String tagged = toBeTagged;
        tagged = tagged.replace("\n", "<br>\n");
        tagged = "<div class=\"ex_code\">\n<br>".concat(tagged);
        tagged = tagged.concat("\n<br></div>");
        return tagged;
    }

    protected abstract void readAnotherImportantFilesIn();

    protected abstract String addAnotherTags(String var1);
}

