import java.util.ArrayList;

import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;


public class Snake {
	
	private Direction direction;
	
	private final String color="yellow";
	
	private ArrayList<DataOfSquareMoving>snakeParts=new ArrayList<DataOfSquareMoving>();
	
	private boolean newPart;
	
	public Snake(int vertical_pos_head, int horizontal_pos_head){
		
		
		snakeParts.add(new DataOfSquareMoving(vertical_pos_head,horizontal_pos_head,color));
		snakeParts.add(new DataOfSquareMoving(vertical_pos_head,horizontal_pos_head+1,color));
		snakeParts.add(new DataOfSquareMoving(vertical_pos_head,horizontal_pos_head+2,color));
		
		direction=Direction.NOWHERE;
		
		newPart=false;
	}
	
	public void setNewPartToTrue(){
		newPart=true;
	}
	
	public void addSnakePart(){

		DataOfSquareMoving dsmLast=snakeParts.get(snakeParts.size()-1);
		
		snakeParts.add(new DataOfSquareMoving(dsmLast.getVERTICAL_POSITION(),dsmLast.getHORIZONTAL_POSITION(),color));
	
		newPart=false;
		
	}
	
	public ArrayList<DataOfSquareMoving> getSnakeParts(){
		return snakeParts;
	}
	
	
	
public void handleSnake(KeyEvent event) {
		if (event.getCode() == KeyCode.W) {
			direction=Direction.NORTH;
		}
		if (event.getCode() == KeyCode.S) {

			direction=Direction.SOUTH;
		}
		if (event.getCode() == KeyCode.A) {

			direction=Direction.WEST;
		}
		if (event.getCode() == KeyCode.D) {

			direction=Direction.EAST;

		}
	
	
	
	}

	public Direction getDirection(){
		return direction;
	}
	
	public void setDirection(Direction d){
		direction=d;
	}
	
	

	public void snakeRun(){
		if(direction==Direction.NOWHERE){
			
		}
		
		
		
		DataOfSquareMoving dsmHead = snakeParts.get(0);
		
		
		if(Controller.SnakeOutOfField(this)==false){
			

			if (direction==Direction.NORTH) {
				for (int i = snakeParts.size() - 1; i > 0; i--) {
					DataOfSquareMoving dsm = snakeParts.get(i);
					dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
							.getVERTICAL_POSITION());
					dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
							.getHORIZONTAL_POSITION());
				}	
				
				dsmHead.setVERTICAL_POSITION(dsmHead.getVERTICAL_POSITION() - 1);
			}
			if (direction==Direction.SOUTH) {
				for (int i = snakeParts.size() - 1; i > 0; i--) {
					DataOfSquareMoving dsm = snakeParts.get(i);
					dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
							.getVERTICAL_POSITION());
					dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
							.getHORIZONTAL_POSITION());
				}
				
				
				dsmHead.setVERTICAL_POSITION(dsmHead.getVERTICAL_POSITION() + 1);
			}
			if (direction==Direction.WEST) {
				for (int i = snakeParts.size() - 1; i > 0; i--) {
					DataOfSquareMoving dsm = snakeParts.get(i);
					dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
							.getVERTICAL_POSITION());
					dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
							.getHORIZONTAL_POSITION());
				}
				
				dsmHead.setHORIZONTAL_POSITION(dsmHead.getHORIZONTAL_POSITION() - 1);
			}
			if (direction==Direction.EAST) {
				for (int i = snakeParts.size() - 1; i > 0; i--) {
					DataOfSquareMoving dsm = snakeParts.get(i);
					dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
							.getVERTICAL_POSITION());
					dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
							.getHORIZONTAL_POSITION());
				}
				
				dsmHead.setHORIZONTAL_POSITION(dsmHead.getHORIZONTAL_POSITION() + 1);

			}

		}else{
				if (direction==Direction.NORTH) {
					for (int i = snakeParts.size() - 1; i > 0; i--) {
						DataOfSquareMoving dsm = snakeParts.get(i);
						dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
								.getVERTICAL_POSITION());
						dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
								.getHORIZONTAL_POSITION());
					}
					
					dsmHead.setVERTICAL_POSITION(Main.NUMBER_OF_SQUARES_VERTICAL-1);
				}
				if (direction==Direction.SOUTH) {
					for (int i = snakeParts.size() - 1; i > 0; i--) {
						DataOfSquareMoving dsm = snakeParts.get(i);
						dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
								.getVERTICAL_POSITION());
						dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
								.getHORIZONTAL_POSITION());
					}
					
					dsmHead.setVERTICAL_POSITION(0);
				}
				if (direction==Direction.WEST) {
					for (int i = snakeParts.size() - 1; i > 0; i--) {
						DataOfSquareMoving dsm = snakeParts.get(i);
						dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
								.getVERTICAL_POSITION());
						dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
								.getHORIZONTAL_POSITION());
					}
					
					dsmHead.setHORIZONTAL_POSITION(Main.NUMBER_OF_SQUARES_HORIZONTAL - 1);
				}
				if (direction==Direction.EAST) {
					for (int i = snakeParts.size() - 1; i > 0; i--) {
						DataOfSquareMoving dsm = snakeParts.get(i);
						dsm.setVERTICAL_POSITION(snakeParts.get(i - 1)
								.getVERTICAL_POSITION());
						dsm.setHORIZONTAL_POSITION(snakeParts.get(i - 1)
								.getHORIZONTAL_POSITION());
					}
					
					dsmHead.setHORIZONTAL_POSITION(0);

				}
		}
		
		if(newPart==true){
			addSnakePart();
		}
	}

	
	


}
