


import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Duration;



public class Main extends Application{

	public Main() {

	}
	


	public static final int WIDTH = 400;
	public static final int HEIGHT = 400;
	
	public static final int NUMBER_OF_SQUARES_VERTICAL=20;
	public static final int NUMBER_OF_SQUARES_HORIZONTAL=20;

	public static void main(String[] args) {
		
		
		launch(args);
	}

	private Snake snake;
	private Apple apple;

	private PlayField playField;
	private DrawPane drawPane;

	private Stage stage;
	
	private Scene scene;
	


	@Override
	public void start(Stage primaryStage) throws Exception {
		// TODO Auto-generated method stub
		stage = primaryStage;

		apple = new Apple(0, 0);
		snake = new Snake(10, 10);

		
		playField = new PlayField(snake.getSnakeParts(), apple.getApplePart());

		drawPane = new DrawPane(playField);
		
		scene=new Scene(drawPane);

		stage.setScene(scene);
		
		
		stage.getIcons().add(new Image("SnakeJavaFX.png"));
		stage.show();

		scene.setOnMouseClicked(new EventHandler<MouseEvent>() {

			@Override
			public void handle(MouseEvent event) {
				// TODO Auto-generated method stub
				System.out.println("a mouseclick");
			}

		});

		scene.setOnKeyPressed(new EventHandler<KeyEvent>() {

			@Override
			public void handle(KeyEvent event) {
				// TODO Auto-generated method stub
				snake.handleSnake(event);
				
				
				
			}

		});
		
		
		
		
		
		
		EventHandler<ActionEvent>gameUpdate=event->{
			
			
			
			snake.snakeRun();
			
			
			
			playField.setPlayField(snake.getSnakeParts(), apple.getApplePart());
			
			
			drawPane.draw(playField);
			
			if(Controller.takeCareIfSnakeHitsApple(snake, apple)==true){
				
				apple.changePosition();
				snake.setNewPartToTrue();
				
			}
			
			
			
		};
		Timeline gameLoop=new Timeline(new KeyFrame(Duration.millis(100),gameUpdate));
		
		gameLoop.setCycleCount(Animation.INDEFINITE);
		
		
		gameLoop.play();
		
		EventHandler<ActionEvent>gameEnd=event->{
				
			if(Controller.takeCareIfSnakeHitsItself(snake)){
				gameLoop.stop();
			}
				
			
		};
		
		Timeline checkEnd=new Timeline(new KeyFrame(Duration.millis(100),gameEnd));
		checkEnd.setCycleCount(Animation.INDEFINITE);
		checkEnd.play();
		
	}
	
	
	
	
	

	

}
