

import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;

import javafx.scene.paint.Paint;


public class DrawPane extends Pane{
	
	private Canvas canvas;
	
	
	
	GraphicsContext gc;
	
	public DrawPane(PlayField playField){
		
		
		
		
		canvas=new Canvas(Main.WIDTH,Main.HEIGHT);
		
		gc=canvas.getGraphicsContext2D();
		
		
		
		this.getChildren().add(canvas);
		
		draw(playField);
	}
	
	public void draw(PlayField playField){
		DataOfSquare[][] ds=playField.getPlayField();
		
		
		for(int i=0;i<ds.length;i++){
			for(int j=0;j<ds.length;j++){
				Paint paint=Paint.valueOf(ds[i][j].getColor());

				gc.setFill(paint);
				
				gc.fillRect(ds[i][j].getY_POS(), ds[i][j].getX_POS(), 20, 20);
				
				gc.setStroke(Paint.valueOf("black"));
				gc.strokeRect(ds[i][j].getY_POS(), ds[i][j].getX_POS(), 20, 20);
				
			}
		}
		
		
	}

}
