/*
 * Decompiled with CFR 0.152.
 */
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Main
extends Application {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 400;
    public static final int NUMBER_OF_SQUARES_VERTICAL = 20;
    public static final int NUMBER_OF_SQUARES_HORIZONTAL = 20;
    private Snake snake;
    private Apple apple;
    private PlayField playField;
    private DrawPane drawPane;
    private Stage stage;
    private Scene scene;

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        this.stage = primaryStage;
        this.apple = new Apple(0, 0);
        this.snake = new Snake(10, 10);
        this.playField = new PlayField(this.snake.getSnakeParts(), this.apple.getApplePart());
        this.drawPane = new DrawPane(this.playField);
        this.scene = new Scene((Parent)this.drawPane);
        this.stage.setScene(this.scene);
        this.stage.getIcons().add((Object)new Image("SnakeJavaFX.png"));
        this.stage.show();
        this.scene.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                System.out.println("a mouseclick");
            }
        });
        this.scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                Main.this.snake.handleSnake(event);
            }
        });
        EventHandler gameUpdate = event -> {
            this.snake.snakeRun();
            this.playField.setPlayField(this.snake.getSnakeParts(), this.apple.getApplePart());
            this.drawPane.draw(this.playField);
            if (Controller.takeCareIfSnakeHitsApple(this.snake, this.apple)) {
                this.apple.changePosition();
                this.snake.setNewPartToTrue();
            }
        };
        Timeline gameLoop = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), gameUpdate, new KeyValue[0])});
        gameLoop.setCycleCount(-1);
        gameLoop.play();
        EventHandler gameEnd = event -> {
            if (Controller.takeCareIfSnakeHitsItself(this.snake)) {
                gameLoop.stop();
            }
        };
        Timeline checkEnd = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), gameEnd, new KeyValue[0])});
        checkEnd.setCycleCount(-1);
        checkEnd.play();
    }
}

